/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.libjf.translate.impl;

import io.gitlab.jfronny.libjf.translate.api.Language;
import io.gitlab.jfronny.libjf.translate.api.TranslateException;
import io.gitlab.jfronny.libjf.translate.api.TranslateService;
import java.util.regex.Pattern;

public abstract class AbstractTranslateService<T extends Language>
implements TranslateService<T> {
    private static final Pattern WHITE_SPACE = Pattern.compile("\\s*");

    @Override
    public String translate(String textToTranslate, T translateFrom, T translateTo) throws TranslateException {
        if (textToTranslate == null) {
            throw new TranslateException("textToTranslate must not be null");
        }
        if (translateFrom == null) {
            translateFrom = this.getAutoDetectLang();
        }
        if (translateTo == null) {
            throw new TranslateException("translateTo must not be null");
        }
        if (WHITE_SPACE.matcher(textToTranslate).matches()) {
            return textToTranslate;
        }
        try {
            return this.performTranslate(textToTranslate, translateFrom, translateTo);
        }
        catch (TranslateException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new TranslateException("Could not translate text", e);
        }
    }

    protected abstract T getAutoDetectLang();

    protected abstract String performTranslate(String var1, T var2, T var3) throws Exception;
}

